/*
 * Decompiled with CFR 0.152.
 */
package virtuoel.pehkui.api;

import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2960;
import org.jetbrains.annotations.ApiStatus;
import virtuoel.kanos_config.api.JsonConfigBuilder;
import virtuoel.kanos_config.api.MutableConfigEntry;
import virtuoel.pehkui.Pehkui;
import virtuoel.pehkui.api.ScaleRegistries;
import virtuoel.pehkui.api.ScaleType;
import virtuoel.pehkui.api.ScaleTypes;
import virtuoel.pehkui.util.ClampingScaleModifier;
import virtuoel.pehkui.util.ConfigSyncUtils;
import virtuoel.pehkui.util.VersionUtils;

public class PehkuiConfig {
    @ApiStatus.Internal
    public static final JsonConfigBuilder BUILDER = new JsonConfigBuilder("pehkui", FabricLoader.getInstance().getConfigDir().resolve("pehkui").resolve("config.json").normalize()){

        public <T> MutableConfigEntry<T> createConfigEntry(String name, T defaultValue, Supplier<T> supplier, Consumer<T> consumer) {
            return ConfigSyncUtils.createConfigEntry(name, defaultValue, supplier, consumer);
        }
    };
    public static final Client CLIENT = new Client(BUILDER);
    public static final Common COMMON = new Common(BUILDER);
    public static final Server SERVER = new Server(BUILDER);

    private PehkuiConfig() {
    }

    private static String synced(String name, String codecKey) {
        ConfigSyncUtils.setupSyncableConfig(name, codecKey);
        return name;
    }

    public static final class Client {
        public final Supplier<Double> minimumCameraDepth;

        private Client(JsonConfigBuilder builder) {
            this.minimumCameraDepth = builder.doubleConfig("minimumCameraDepth", 3.051850947599719E-5);
        }
    }

    public static final class Common {
        public final Supplier<Boolean> keepAllScalesOnRespawn;
        public final Supplier<List<String>> scalesKeptOnRespawn;
        public final Supplier<Boolean> accurateNetherPortals;
        public final Supplier<Boolean> enableCommands;
        public final Supplier<Boolean> enableDebugCommands;
        public final Supplier<Boolean> scaledFallDamage;
        public final Supplier<Boolean> scaledMotion;
        public final Supplier<Boolean> scaledReach;
        public final Supplier<Boolean> scaledAttack;
        public final Supplier<Boolean> scaledDefense;
        public final Supplier<Boolean> scaledHealth;
        public final Supplier<Boolean> scaledItemDrops;
        public final Supplier<Boolean> scaledProjectiles;
        public final Supplier<Boolean> scaledExplosions;

        private Common(JsonConfigBuilder builder) {
            this.keepAllScalesOnRespawn = builder.booleanConfig(PehkuiConfig.synced("keepAllScalesOnRespawn", "boolean"), false);
            this.scalesKeptOnRespawn = builder.stringListConfig(PehkuiConfig.synced("scalesKeptOnRespawn", "string_list"));
            this.accurateNetherPortals = builder.booleanConfig(PehkuiConfig.synced("accurateNetherPortals", "boolean"), true);
            this.enableCommands = builder.booleanConfig("enableCommands", true);
            this.enableDebugCommands = builder.booleanConfig("enableDebugCommands", false);
            this.scaledFallDamage = builder.booleanConfig(PehkuiConfig.synced("scaledFallDamage", "boolean"), true);
            this.scaledMotion = builder.booleanConfig(PehkuiConfig.synced("scaledMotion", "boolean"), true);
            this.scaledReach = builder.booleanConfig(PehkuiConfig.synced("scaledReach", "boolean"), true);
            this.scaledAttack = builder.booleanConfig(PehkuiConfig.synced("scaledAttack", "boolean"), true);
            this.scaledDefense = builder.booleanConfig(PehkuiConfig.synced("scaledDefense", "boolean"), true);
            this.scaledHealth = builder.booleanConfig(PehkuiConfig.synced("scaledHealth", "boolean"), true);
            this.scaledItemDrops = builder.booleanConfig(PehkuiConfig.synced("scaledItemDrops", "boolean"), true);
            this.scaledProjectiles = builder.booleanConfig(PehkuiConfig.synced("scaledProjectiles", "boolean"), true);
            this.scaledExplosions = builder.booleanConfig(PehkuiConfig.synced("scaledExplosions", "boolean"), true);
            for (Map.Entry entry : ScaleRegistries.SCALE_TYPES.entrySet()) {
                ScaleType type;
                class_2960 id = (class_2960)entry.getKey();
                String namespace = id.method_12836();
                if (!namespace.equals("pehkui") || (type = (ScaleType)entry.getValue()) == ScaleTypes.INVALID) continue;
                String path = id.method_12832();
                Supplier min = builder.doubleConfig(PehkuiConfig.synced(path + ".minimum", "double"), type.getAffectsDimensions() ? 1.262177448353619E-29 : (double)1.4E-45f);
                Supplier max = builder.doubleConfig(PehkuiConfig.synced(path + ".maximum", "double"), (type == ScaleTypes.BLOCK_REACH || type == ScaleTypes.ENTITY_REACH) && VersionUtils.MINOR < 17 ? 128.0 : 3.4028234663852886E38);
                type.getDefaultBaseValueModifiers().add(ScaleRegistries.register(ScaleRegistries.SCALE_MODIFIERS, Pehkui.id("clamping", path), new ClampingScaleModifier(((Supplier)min)::get, ((Supplier)max)::get, 0.0f)));
            }
        }
    }

    public static final class Server {
        private Server(JsonConfigBuilder builder) {
        }
    }
}

